/*
 * Decompiled with CFR 0.152.
 */
package io.github.cat24a.klowenia_tales.scene;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.utils.ScreenUtils;
import io.github.cat24a.klowenia_tales.Main;
import io.github.cat24a.klowenia_tales.scene.Scene;
import io.github.cat24a.klowenia_tales.scene.World;
import io.github.cat24a.klowenia_tales.util.GraphicsUtil;
import io.github.cat24a.klowenia_tales.util.Hash;

public class Drawer
implements Scene {
    static final Rectangle handle_location = new Rectangle(-11.0f, -47.0f, 22.0f, 6.0f);
    public final World world;
    public final DrawerItem[] stuff;
    public DrawerItem dragged_item;

    public Drawer(Main game, World world, boolean hasKey) {
        this.world = world;
        this.stuff = new DrawerItem[MathUtils.random(15, 25)];
        for (int i = 0; i < this.stuff.length; ++i) {
            this.stuff[i] = new DrawerItem(game.assets.DRAWER_TRASH[MathUtils.random(game.assets.DRAWER_TRASH.length - 1)]);
        }
        if (hasKey) {
            this.stuff[0] = new DrawerItem(game.assets.KEY_BIG);
            this.stuff[0].isKey = true;
        }
    }

    @Override
    public void draw(Main game) {
        this.logic(game);
        ScreenUtils.clear(0.05f, 0.05f, 0.05f, 1.0f);
        GraphicsUtil.drawCentered(game, game.assets.DRAWER_BACKGROUND, 0.0f, 0.0f);
        GraphicsUtil.drawCentered(game, game.assets.DRAWER_TOP, 0.0f, 76.0f);
        for (DrawerItem drawerItem : this.stuff) {
            GraphicsUtil.drawCentered(game, drawerItem.texture, drawerItem.position.x, drawerItem.position.y);
        }
    }

    private void logic(Main game) {
        if (Gdx.input.justTouched()) {
            for (int i = this.stuff.length - 1; i >= 0; --i) {
                if (!this.stuff[i].getRect().contains(game.touchPos)) continue;
                if (this.stuff[i].isKey) {
                    this.world.unlockedDoors.add(Hash.roomHash(this.world.roomx, this.world.roomy));
                    game.scene = this.world;
                }
                this.dragged_item = this.stuff[i];
                break;
            }
            if (this.dragged_item == null && handle_location.contains(game.touchPos)) {
                game.scene = this.world;
            }
        }
        if (this.dragged_item == null) {
            return;
        }
        if (Gdx.input.isTouched()) {
            this.dragged_item.position.set(game.touchPos);
        } else {
            this.dragged_item = null;
        }
    }

    class DrawerItem {
        Vector2 position;
        TextureRegion texture;
        boolean isKey = false;

        DrawerItem(TextureRegion texture) {
            this.texture = texture;
            this.position = new Vector2(MathUtils.random(-45, 45), MathUtils.random(-23, 23));
        }

        Rectangle getRect() {
            return GraphicsUtil.centeredRectangle(this.position.x, this.position.y, this.texture.getRegionWidth(), this.texture.getRegionHeight());
        }
    }
}

